﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace WhatButtonWasThat
{
    public class Line
    {
        Texture2D mSquare;
        
        public Vector2 EndPointOne;
        public Vector2 EndPointTwo;
        public Color LineColor = Color.Black;

        public Line(Vector2 thePointOne, Vector2 thePointTwo, ContentManager theContent)
        {
            EndPointOne = thePointOne;
            EndPointTwo = thePointTwo;

            mSquare = theContent.Load<Texture2D>("Square");
        }

        public void Draw(SpriteBatch theSpriteBatch)
        {
            float aDistance = Vector2.Distance(EndPointOne, EndPointTwo);
            float aRotationAngle = (float)Math.Atan2((double)(EndPointTwo.Y - EndPointOne.Y),
                (double)(EndPointTwo.X - EndPointOne.X));

            theSpriteBatch.Draw(mSquare, EndPointOne, new Rectangle(0, 0, 1, 1), LineColor,
                aRotationAngle, Vector2.Zero, new Vector2(aDistance, 1), SpriteEffects.None, 0);
        }       
    }
}
