﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace WhatButtonWasThat
{
    class HowToPlay
    {
        Texture2D mControllerFront;
        Texture2D mControllerTop;

        Viewport mViewport;
        ContentManager mContent;

        Vector2 mControllerFrontPosition;
        Vector2 mControllerTopPosition;

        SpriteFont mControllerText;

        Dictionary<Buttons, Line> mControllerLines;

        public string DPadText = string.Empty;

        public string LeftThumbStickText = string.Empty;
        public string RightThumbStickText = string.Empty;

        public string LeftShoulderText = string.Empty;
        public string RightShoulderText = string.Empty;

        public string LeftTriggerText = string.Empty;
        public string RightTriggerText = string.Empty;

        public string BackButtonText = string.Empty;
        public string StartButtonText = string.Empty;

        public string AButtonText = string.Empty;
        public string BButtonText = string.Empty;
        public string XButtonText = string.Empty;
        public string YButtonText = string.Empty;
        
        bool mIsControllerTopDisplayed = true;
        
        public HowToPlay(ContentManager theContent, Viewport theViewport, GraphicsDevice theGraphicsDevice)
        {
            mViewport = theViewport;
            mContent = theContent;

            mControllerFront = theContent.Load<Texture2D>("con_front_ortho");
            mControllerTop = theContent.Load<Texture2D>("con_top_ortho");
            mControllerText = theContent.Load<SpriteFont>("ControllerText");
        
            PositionControllerImages();
            InitializeControllerLines();
        }

        private void PositionControllerImages()
        {
            mIsControllerTopDisplayed = true;
            if (LeftShoulderText == string.Empty && RightShoulderText == string.Empty
                && LeftTriggerText == string.Empty && RightTriggerText == string.Empty)
            {
                mIsControllerTopDisplayed = false;  
            }

            int aControllerTopHeight = 0;
            if (mIsControllerTopDisplayed)
            {
                aControllerTopHeight = mControllerTop.Height;
            }

            int aYPosition = (int)((mViewport.Height - (aControllerTopHeight + mControllerFront.Height + 20)) / 2);

            mControllerFrontPosition.X = (int)((mViewport.Width - mControllerFront.Width) / 2);
            mControllerTopPosition.X = (int)((mViewport.Width - mControllerTop.Width) / 2);

            mControllerTopPosition.Y = aYPosition;
            mControllerFrontPosition.Y = aControllerTopHeight + mControllerTopPosition.Y + 20;
        }

        private void InitializeControllerLines()
        {
            int aYOffset = 0;
            if (!mIsControllerTopDisplayed)
            {
                aYOffset = 100;
            }

            mControllerLines  = new Dictionary<Buttons, Line>();

            mControllerLines.Add(Buttons.DPadDown, new Line(new Vector2(279, 468 - aYOffset), new Vector2(565, 468 - aYOffset), mContent));

            mControllerLines.Add(Buttons.X, new Line(new Vector2(896, 345 - aYOffset), new Vector2(740, 385 - aYOffset), mContent));
            mControllerLines.Add(Buttons.Y, new Line(new Vector2(896, 305 - aYOffset), new Vector2(777, 350 - aYOffset), mContent));
            mControllerLines.Add(Buttons.A, new Line(new Vector2(896, 425 - aYOffset), new Vector2(776, 425 - aYOffset), mContent));
            mControllerLines.Add(Buttons.B, new Line(new Vector2(896, 385 - aYOffset), new Vector2(815, 385 - aYOffset), mContent));

            mControllerLines.Add(Buttons.Back, new Line(new Vector2(420, 270 - aYOffset), new Vector2(590, 390 - aYOffset), mContent));
            mControllerLines.Add(Buttons.Start, new Line(new Vector2(860, 270 - aYOffset), new Vector2(690, 390 - aYOffset), mContent));

            mControllerLines.Add(Buttons.LeftStick, new Line(new Vector2(380, 390 - aYOffset), new Vector2(505, 390 - aYOffset), mContent));
            mControllerLines.Add(Buttons.RightStick, new Line(new Vector2(928, 470 - aYOffset), new Vector2(703, 470 - aYOffset), mContent));

            mControllerLines.Add(Buttons.LeftShoulder, new Line(new Vector2(335, 208 - aYOffset), new Vector2(495, 208 - aYOffset), mContent));
            mControllerLines.Add(Buttons.RightShoulder, new Line(new Vector2(940, 208 - aYOffset), new Vector2(780, 208 - aYOffset), mContent));

            mControllerLines.Add(Buttons.LeftTrigger, new Line(new Vector2(350, 150 - aYOffset), new Vector2(510, 150 - aYOffset), mContent));
            mControllerLines.Add(Buttons.RightTrigger, new Line(new Vector2(925, 150 - aYOffset), new Vector2(765, 150 - aYOffset), mContent));
        }

        public void Draw(SpriteBatch theBatch)
        {
            //Reposition the Controller images and re-position all the lines
            PositionControllerImages();
            InitializeControllerLines();

            //Draw the Top and Front controller images. If any of the top buttons 
            //have been assigned text, then the top controller image
            //will be drawn, otherwise, just the front view will be drawn
            if (mIsControllerTopDisplayed)
            {
                theBatch.Draw(mControllerTop, mControllerTopPosition, Color.White);
            }             
            theBatch.Draw(mControllerFront, mControllerFrontPosition, Color.White);

            //Draw the controller text assigned for each button on the Controller
            DrawControllerText(DPadText, Buttons.DPadDown, theBatch, true);
            DrawControllerText(AButtonText, Buttons.A, theBatch, false);
            DrawControllerText(BButtonText, Buttons.B, theBatch, false);
            DrawControllerText(XButtonText, Buttons.X, theBatch, false);
            DrawControllerText(YButtonText, Buttons.Y, theBatch, false);            
            DrawControllerText(LeftThumbStickText, Buttons.LeftStick, theBatch, true);
            DrawControllerText(RightThumbStickText, Buttons.RightStick, theBatch, false);
            DrawControllerText(LeftTriggerText, Buttons.LeftTrigger, theBatch, true);
            DrawControllerText(RightTriggerText, Buttons.RightTrigger, theBatch, false);
            DrawControllerText(LeftShoulderText, Buttons.LeftShoulder, theBatch, true);
            DrawControllerText(RightShoulderText, Buttons.RightShoulder, theBatch, false);
            DrawControllerText(BackButtonText, Buttons.Back, theBatch, true);
            DrawControllerText(StartButtonText, Buttons.Start, theBatch, false);
        } 

        //Draw the Line and the Text that accompanies it
        private void DrawControllerText(string theButtonText, Buttons theButton, SpriteBatch theBatch, bool isLeft)
        {
            if (theButtonText != string.Empty)
            {
                mControllerLines[theButton].LineColor = Color.Black;
                mControllerLines[theButton].Draw(theBatch);

                int aXPosition = 0;
                if (isLeft)
                {
                    aXPosition = (int)mControllerLines[theButton].EndPointOne.X - (int)mControllerText.MeasureString(theButtonText).X;
                }
                else
                {
                    aXPosition = (int)mControllerLines[theButton].EndPointOne.X;                 
                }

                int aYPosition = (int)mControllerLines[theButton].EndPointOne.Y - (int)(mControllerText.MeasureString(theButtonText).Y / 2);

                theBatch.DrawString(mControllerText, theButtonText, new Vector2(aXPosition, aYPosition), Color.Black);
            }
        }
    
    }
}
